/* ============ */
/* cupontst.c	*/
/* ============ */
#include <defcodes.h>
#include <miscdefs.h>
#include <cupndefs.h>
#include <math.h>
#include <mconf.h>

#define	NUM_PROBS	100

static	COUPON_DATA_STRU CouponData;
static	INIT_DATA_STRU   InitialData;

/* ==================================================================== */
/* CouponTest - Executes Coupon Collector's Test per Knuth		*/
/* ==================================================================== */
void
main(void)
{
    int	    k;
    long    TotVariates = 0;
    double  DegFree;
    double  KnMinusProb, KnMinusStat, KnPlusProb, KnPlusStat;

    double  ChiSqProb[NUM_PROBS];

    AbortGracefully();			/* Make ^C act reasonably */

    printf("\tC O U P O N  T E S T\n\n");
    GetInitialData(&InitialData);
    fprintf(stderr, "\n");fflush(NULL);

    /* -------------------------- */
    /* Print Initial Data Entries */
    /* -------------------------- */
    printf("Starting Seed = %u%s\n", InitialData.UserSeed,
	(InitialData.SeedSrce == (UINT)(-1)) ?
		" (Unsigned Integer Part of Time of Day)" : "");

    printf("Generator     = %s\n", InitialData.GenName);

    CouponData.RandFun = InitialData.RandFun;
    SetCouponControls(&CouponData);

    if (!CouponData.CallStatusOK)
    {
	printf("At Least One Category Has a Cell Expectation Less"
		" Than Number Requested.\n");
	printf("Run plancupn.exe to Determine Appropriate Number of"
		" Coupons to be Counted.\n");
	printf("For the Inputs That You Have Provided At Least %ld"
		" Coupons are Required.\n", CouponData.UserNumCoupons);
	if (CouponData.UserCellExpect != MIN_CELL_XPCT)
	{
	    printf("For a Minimum of %d Samples Per Category At"
		" Least %ld Coupons are Required.\n", MIN_CELL_XPCT,
		CouponData.IdealNumCoupons);
	}
    }

    DegFree = CouponData.NumCategories - CouponData.NotEnough - 1;

    /* ------------------------- */
    /* Generate Random Numbers,  */
    /* Calculate Chi-Square Data */
    /* ------------------------- */
    fflush(NULL);
    for (k = 0; k < NUM_PROBS; ++k)
    {
	CalcCouponChiSq(&CouponData);

	fprintf(stderr, "\rPass %3d (of %d), %8ld  Total Random Numbers",
	    k+1, NUM_PROBS, TotVariates += CouponData.TotNumGen);

	if (!CouponData.CallStatusOK)
	{
	    printf("Generator Failed to Produce a Coupon "
		   "Within %ld Cycles\n", CouponData.MaxGenPerSeg);
	    break;
	}
	ChiSqProb[k] = chdtr(DegFree, CouponData.CouponChiSq);

	if (ChiSqProb[k] < 0)
	{
	    fprintf(stderr, "\nChiSqFreq(): Function chdtr() "
		"Returned Negative Probability -  Can't Happen.\n");
	}

	P(printf("Coupon Chi-Square Statistic = %f\n",
	    CouponData.CouponChiSq));
	P(printf("Total Number Variates Generated   = %ld\n",
	    CouponData.TotNumGen));
	P(printf("Maximum No. Variates for a Coupon = %ld\n",
	    CouponData.ActMaxPerSeg));
	P(printf("Chi-Square Probability on %.f"
		" Degrees of Freedom = %.4f\n", DegFree, ChiSqProb[k]));
    }

    P(printf("\nCouponData.CallStatusOK = %s\n",
	(CouponData.CallStatusOK == 0) ? "FALSE" : "TRUE"));

    /* -------------------------------------------------------- */
    /* Calculate K-S on Chi-Square Statistics and Probabilities */
    /* -------------------------------------------------------- */
    if (CouponData.CallStatusOK)
    {
	KSCalc(ChiSqProb, NUM_PROBS,
		&KnPlusStat, &KnPlusProb,
 		&KnMinusStat, &KnMinusProb);

	fprintf(stderr, "\n");fflush(NULL);
	printf("\nKolmogorov-Smirnov Statistics and Probabilities"
		" on Chi-Square Data\n");

	if (KnPlusProb < 0)
	{
	    printf("ERROR:  KnPlusStat = %.11e\n", KnPlusStat);
	}
	else
	{
	    printf("\tK(%d)+ = %f (Knuth) or %9f%%\n", NUM_PROBS,
		KnPlusStat * sqrt((double)NUM_PROBS), 100*KnPlusProb);
	}

	if (KnMinusProb < 0)
	{
	    printf("ERROR:  KnMinusStat = %.11e\n", KnMinusStat);
	}
	else
	{
	    printf("\tK(%d)+ = %f (Knuth) or %9f%%\n", NUM_PROBS,
		KnMinusStat * sqrt((double)NUM_PROBS), 100*KnMinusProb);
	}

	printf("\nThis Run Required %ld Random Numbers\n", TotVariates);
    }
}
